<?php
/*
  {{Root}} outputs UWikiSettings->rootURL, {{Path}} - baseURL (can be empty),
  Also available are {{MediaURL}} and {{SmileyURL}}.

  Naming is similar to interwiki.conf's {ROOT} and {PATH} except that they're not case-sensitive.
  All actions output paths without trailing slash so to get an absolute path to current
  page you can write {{Root}}/{{Path}}
*/

class Uroot_Root extends UWikiBaseAction {
  public $htmlTag = 'span';
  public $htmlClasses = array('root-url');

  function Execute($format, $params) { $format->appendMe = true; }

  function SelfToHtmlWith($contents) {
    $path = rtrim($this->GetURL(), '\\/');
    if (!self::IsEmptyStr($path)) {
      return parent::SelfToHtmlWith( self::QuoteHTML($path) );
    }
  }

    function GetURL() { return $this->settings->rootURL; }
}

  class Upath_Root extends Uroot_Root {
    public $htmlClasses = array('base-url');
    function GetURL() { return $this->settings->BaseURL(); }
  }

  class Umediaurl_Root extends Uroot_Root {
    public $htmlClasses = array('media-url');
    function GetURL() { return $this->settings->mediaURL; }
  }

  class Usmileyurl_Root extends Uroot_Root {
    public $htmlClasses = array('smiley-url');
    function GetURL() { return $this->settings->smileyURL; }
  }
